#!/bin/bash
export datasets1="Cora CiteSeer PubMed"
export datasets2="physics OGBN-Arxiv"
export missing_rates="0.0 0.9 0.999 0.9999"
export train_ratios="0.1"
# export train_ratios="0.001"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 0.0001 0.001 0.01 0.1 1 10"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=2

# for dataset in $datasets1
# do
# for train_ratio in $train_ratios
# do
# python main.py --dataset ${dataset} --missing_type uniform --missing_rate 0.0 --train_ratio ${train_ratio} --embedder Node2Vec --n_runs 3 --gpu ${gpu}
# # python main.py --dataset ${dataset} --missing_type row --missing_rate 0.0 --train_ratio ${train_ratio} --embedder Node2Vec --n_runs 3 --gpu ${gpu}
# done
# done

for dataset in $datasets1
do
for missing_rate in $missing_rates
do
for train_ratio in $train_ratios
do
python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder node2vec_gnn_concat_1 --gnn GCN --filling_method fp --n_runs 3 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type row --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder node2vec_gnn_concat_1 --gnn GCN --filling_method fp --n_runs 3 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder node2vec_gnn_concat_1 --gnn GCN --filling_method fp --label_trick True --mask_rate 1.0 --n_runs 3 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type row --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder node2vec_gnn_concat_1 --gnn GCN --filling_method fp --label_trick True --mask_rate 1.0 --n_runs 3 --gpu ${gpu}
done
done
done